/*****************************************************************************/
/*                                Includes
/*****************************************************************************/

  #include "MainMenu.h"
  #include "Rend_Characters.h"
  #include "Table.h"

/*****************************************************************************/
/*                                 Globals
/*****************************************************************************/

  extern UINT8 au8FileNames[FILES_TO_CHECK][12] ={
  {"TABLE.CSV"},
  {"FSLLOGO.AMI"},
  {"USELICO.AMI"},
  {"HRICO.AMI"},
  {"FIICO.AMI"},
  {"PEDOICO.AMI"},
  {"DATAICO.AMI"},
  {"ZIGBICO.AMI"},
  {"TIMEICO.AMI"},
  {"MAINMENU.AMI"}
  };
  
  extern UINT8 au8MenuIcon[7][12] ={
  {"USELICO.AMI"},
  {"HRICO.AMI"},
  {"FIICO.AMI"},
  {"PEDOICO.AMI"},
  {"TIMEICO.AMI"},
  {"DATAICO.AMI"},
  {"ZIGBICO.AMI"},  
  };
  
  UINT8 u8sd_status;
  
  UINT8 batteryflag=0;
  UINT8 charging;
  UINT8 batteryvoltage;

/*****************************************************************************/
/*                            System Init
/*****************************************************************************/

void SYS_Init(void){

  vfnStart_TFT();                                       // Init TFT Display
  vfnSD_Files_Check();                                  // Check SD Files  
  vfnWelcome_Screen();                                  // Load Main Application
  u32Steps_Counter=u32StepsCountSDHandler(LOAD_STEPS);  // Load Steps
  Calctr=u32CaloriesCountSDHandler(LOAD_CALORIES);      // Load Calories
  ADC_Init();
  
}


/*****************************************************************************/
/*                            Main Menu Routine
/*****************************************************************************/

void vfnMainMenu (void){
  
  UINT8 u8MainIndex=1;     // Set Main Menu Options Index
  
  //vfnRun_Menu_Program(1);
  
  charging=!PTFD_PTFD4;
  // CARGANDO
  if(charging){
    batteryflag =0;
  } 
  
  // NO CARGANDO
  if(!charging) {
    batteryflag =1;  
  }
  
  while(1){                // Loop Main Application
    
    TSS_Task();            // Touch Sensing Task
    
    vfnBattery_Monitor();
   
    switch (gu8ButtonStatus){
   
      /* LEFT OPTION */
      case BUTTON_LEFT:
        u8MainIndex--;
        if(u8MainIndex<1){
           u8MainIndex=6;
        }
        vfnPrint_SD_Image("USELICO.AMI",2,0);
        vfnPrint_Icon(u8MainIndex);
        gu8ButtonStatus=BUTTON_IDDLE;
        break;
      
      /* RIGHT OPTION */
      case BUTTON_RIGHT:
        u8MainIndex++;
        if(u8MainIndex>6){
          u8MainIndex=1;
        }
        vfnPrint_SD_Image("USELICO.AMI",2,0);
        vfnPrint_Icon(u8MainIndex);
        gu8ButtonStatus=BUTTON_IDDLE;
        break;    
      
      /* SELECT APPLICATION */
      case BUTTON_SELECT:
        vfnRun_Menu_Program(u8MainIndex);
        gu8ButtonStatus=BUTTON_IDDLE;
        break; 
      
      /* DEFAULT */
      default:
        gu8ButtonStatus=BUTTON_IDDLE;
        break;
     
    }

  }

}

/*****************************************************************************/
/*                              Battery Monitor
/*****************************************************************************/

void vfnBattery_Monitor(void){

    /* ACTUALIZAR BATERIA */
  charging=!PTFD_PTFD4;

  // CARGANDO
  if(charging && !batteryflag){
    batteryflag =1;
    colorArea(112,117,7,19, 0xFF, 0xFF);      
  }
  
  // NO CARGANDO
  if(batteryflag && !charging) { 
    
    colorArea(111,117,6,19, 0x11, 0x6A); //EMPTY BATTERY
    
    
    ADCSC1A = 0x0B; 
    while(!ADCSC1A_COCOA){}
    batteryvoltage = ADCRHA;
    
    // PRINT THE LINES
    if(batteryvoltage>135){
      colorArea(112,117, 7, 7,0xBE,0x19);
      colorArea(112,117, 8, 8,0xFF,0xFF); //1st LINE
      colorArea(112,117, 9, 9,0xBE,0x19);
    }
    if(batteryvoltage>141){
      colorArea(112,117,11,12,0xFF,0xFF); //2nd LINE
    }
    if(batteryvoltage>148){
      colorArea(112,117,14,14,0xBE,0x19);
      colorArea(112,117,15,15,0xFF,0xFF); //3th LINE
      colorArea(112,117,16,16,0xBE,0x19);
    }
    if(batteryvoltage>155){
      colorArea(112,117,18,19,0xFF,0xFF); //4th LINE
    }
    
    batteryflag =0;  
  }
  
}

 
/*****************************************************************************/
/*                          Check SD Files Routine
/*****************************************************************************/
 
void vfnSD_Files_Check (void){

  UINT8 u8FilesCounter;
  
  /* Write Checking SD Files */
  Fulldisplay(Convert_888_to_565(White,HIGHBYTE), Convert_888_to_565(White,LOWBYTE));
  New_fntcolor(Black,White);
  Write_Str_LCD("Checking SD files...",80,30);
  
  /* Configure SPI module and File System to handle a SD card */
  /* Checking for SD Card */
  u8sd_status = SD_Init();  
  
  
  if(u8sd_status == NO_SD_CARD){       
    /* No SD Card Screen */
    Fulldisplay(Convert_888_to_565(Darkblue,1),Convert_888_to_565(Darkblue,0));
    New_fntcolor(White,Darkblue);
    Write_Str_LCD("SD Card not found",70,30);
    Write_Str_LCD("please insert and reebot",55,15); 
    DisableInterrupts;
    for(;;){};
           
  }else{      
    
    /* Read SD Master Block */
    FAT_Read_Master_Block();    
    
    /* Check each file Routine */
    for(u8FilesCounter=0;u8FilesCounter<FILES_TO_CHECK;u8FilesCounter++){
              
      u8sd_status = FAT_FileOpen(&au8FileNames[u8FilesCounter][0],READ);
      
      /* File X not Found */ 
      if(u8sd_status != FILE_FOUND){
        Fulldisplay(Convert_888_to_565(Darkblue,1),Convert_888_to_565(Darkblue,0));
        New_fntcolor(White,Darkblue);
        Write_Str_LCD("Files can not be found SD may",100,0);
        Write_Str_LCD("be corrupt please install a ",85,0);
        Write_Str_LCD("backup",70,0);
        Write_Str_LCD("Missing file:",40,0);
        Write_Str_LCD(&au8FileNames[u8FilesCounter][0],25,0); 
        DisableInterrupts;   //Disable interrupts
        for(;;){}; 
      }
        
    }
  
  }
   
  Write_Str_LCD("Done!!",45,68);    // All of the files were found!
  
}

/*****************************************************************************/
/*                        TFT Display Initialization
/*****************************************************************************/

void vfnStart_TFT (void){
   
   /* Set LCD Port as outputs */
   P_VALOR(0xFF);   
   PTEDD_PTEDD1=1;       
   PTEDD_PTEDD2=1;       
   PTEDD_PTEDD3=1;
   PTHDD_PTHDD1=1;      
   PTJDD_PTJDD6=1;
                            
   /* LCD Initialization */
   VALOR(0x00);   // Set LCD Port
   resetLCD();    // Reset LCD
   init_LCD();    // Init Routine
   
}
  
/*****************************************************************************/
/*                             Print SD Image
/*****************************************************************************/

void vfnPrint_SD_Image (UINT8 *pu8FileName, UINT8 u8Xspos, UINT8 u8Yspos){

  /***********************************************************************/
  /*Warning!! for .AMI (Activity Monitor Image) format only
  /*
  /*First byte is X size
  /*Second byte is Y size
  /*The remaining bytes are data in 565 color format
  /***********************************************************************/  
   
  volatile UINT16 u16SD_Phyblocksize=0;
  volatile UINT16 u16SD_Bufferindex;
  volatile UINT8 SD_Status;
  volatile UINT8 u8DataToSend;
   
  UINT8 u8Imgbuffer[512];
  UINT8 u8Xepos=0,u8Yepos=0,u8FirstRead=True;


  SD_Status= FAT_FileOpen(pu8FileName,READ);
   
  if(SD_Status==FILE_FOUND && !SD_PRESENT){    

    do{  
        
      /* FAT_FileRead returns how many bytes were read */
      /* Read a complete file, this function will be invoked until it returns zero */
      u16SD_Phyblocksize = FAT_FileRead(u8Imgbuffer);       
      
      /* Set Drawing Area */
      if(u8FirstRead){
      
        u8Xepos=u8Xspos+u8Imgbuffer[0]-1;
        u8Yepos=u8Yspos+u8Imgbuffer[1]-1;
         
        comm_out(0x2A);		  // LCD Column Address Set
        data_out(0x00);	
        data_out(u8Xspos);	// LCD Start Column xs
        data_out(0x00);
        data_out(u8Xepos);	// LCD End Column xe

        comm_out(0x2B);		  // LCD Line Address Set
        data_out(0x00);
        data_out(u8Yspos);	// LCD Start Line ys
        data_out(0x00);
        data_out(u8Yepos);  // LCD End Line ye
  
        comm_out(0x2C);	    // LCD Write to Frame Memory
        
        RS = 1;	 					  // LCD Data register
      } 
        
      /* Drawing SD Image */
      for(u16SD_Bufferindex=0; u16SD_Bufferindex<u16SD_Phyblocksize; u16SD_Bufferindex++){
        
        /* First Read */
        if(u8FirstRead){
          u16SD_Bufferindex=2;
          u8FirstRead=False;
        }
        
        /* Set 8 Hight bits of RGB Image */  
        u8DataToSend=(UINT8)u8Imgbuffer[u16SD_Bufferindex];   
        VALOR(u8DataToSend);
        WR1 = 0;		
        WR1 = 1;
          		                    
        u16SD_Bufferindex++;       
        
        /* Set 8 Low bits of RGB Image */  
        u8DataToSend=(UINT8)u8Imgbuffer[u16SD_Bufferindex];   
        VALOR(u8DataToSend);
        WR1 = 0;		
        WR1 = 1;		                    
      
      }
    
    }
      
    while (u16SD_Phyblocksize);
      
    /* Return to Complete LCD Drawing Area */
    
    comm_out(0x2A);				// Column Address Set
    data_out(0x00);	
    data_out(0x00);				// Start Column 0x0000 = 0
    data_out(0x00);
    data_out(0x7F);				// End Column 0x007F = 127
      
    comm_out(0x2B);				// Line Address Set
    data_out(0x00);
    data_out(0x00);				// Start Line 0x0000 = 0
    data_out(0x00);
    data_out(0x9F); 			// End Line 0x009F = 159
   
    comm_out(0x2C);		    // Write to Frame Memory
 
  }else{
   
    /* Print File X not Found */
    Fulldisplay(Convert_888_to_565(Darkblue,1),Convert_888_to_565(Darkblue,0));
    New_fntcolor(White,Darkblue);
    Write_Str_LCD("Files can not be found SD may",100,0);
    Write_Str_LCD("be corrupt please install a ",85,0);
    Write_Str_LCD("backup",70,0);
    Write_Str_LCD("Missing file:",40,0);
    Write_Str_LCD(pu8FileName,25,0); 
    DisableInterrupts;
    for(;;){};
     
  }
   
}

/*****************************************************************************/
/*                        Initialization Loading Bar
/*****************************************************************************/

void vfnLoading_Bar (void){

  UINT8 u8BarPosition;
  UINT8 u8ColorIndex, u8ColorPosition;
 
  u8BarPosition=10;
  u8ColorIndex=3;
  u8ColorPosition=0;
 
  New_fntcolor(Green,White);  // Loading Bar Colors
 
 /* Print Loading Bar */
  while (u8BarPosition<149){
  
    delay(300);
    /* Print Colored Loading Bar Area */               
    colorArea(15,30,u8BarPosition,(u8BarPosition+1),LookUpTable[u8ColorIndex][0],LookUpTable[u8ColorIndex][1]);
    u8BarPosition++;
    u8ColorPosition++;
    /* Go to de next Area and next Color Index */
    if(u8ColorPosition==12){
      u8ColorPosition=0;
      u8ColorIndex++;
    }
  
  }

}

/*****************************************************************************/
/*                  Display Main Menu Background Image & Icons
/*****************************************************************************/

void vfnWelcome_Screen (void){

  UINT8 u8IconCounter;
  
  /* Print Freescale Logo */
  Fulldisplay(Convert_888_to_565(White,HIGHBYTE),Convert_888_to_565(White,LOWBYTE));  
  vfnPrint_SD_Image("FSLLOGO.AMI",0,16);
  /* Loading Bar */
  vfnLoading_Bar();
  
  /* Check if there is personal data Saved */
  vfnCheckSDforPersonalData();
  
  /* Display Main Menu Images */
  vfnPrint_SD_Image("MAINMENU.AMI",0,0);  
  vfnPrint_SD_Image("USELICO.AMI",2,0);
  vfnPrint_Icon(1);
}

/*****************************************************************************/
/*                        Print Main Menu Selected Icon
/*****************************************************************************/

void vfnPrint_Icon (UINT8 u8IconIndex){

 UINT8 u8Yposition;
 
 /* Print as Highlighted the Main Menu Selected Icon */
 u8Yposition=(u8IconIndex*26)-24;
 vfnPrint_SD_Image(&au8MenuIcon[u8IconIndex][0],2,u8Yposition);

}

/*****************************************************************************/
/*                   Activity Monitor Applications Routines
/*****************************************************************************/

void vfnRun_Menu_Program (UINT8 u8ProgramIndex){

  UINT8 u8IconCounter;
 
  /* This will Switch Between the diferent Applications */
  switch(u8ProgramIndex){    
    
    case 1:      
      /**************************************************************************/
      /*                          Heart Rate Routine
      /**************************************************************************/
      /* Init and Configure OPAMPs and TRIAMPs */
      opamp1_gp_mode() ;                                                       
      opamp2_noninverting_mode(AmpGain[u8Gain_index]);                         
      TRIAMP1C0_HighMode();                                                    
      TRIAMP2C0_HighMode();                                                     
                                                                           
      /* ECG System Init */
      ADC_Init();               // Init ADC                                                                                                   
      ECG_ENABLE=ON;            // ECG Flag in TIMER2
      Index = FLT_ORDER-1;      // Set Filter Order
      TFT_init();               // Init TFT Display                                       
      PTDDD_PTDDD3 = 1;         // Buzzer Port as Output      
      PTED_PTED7 = 0;           // Active low for medical port enabling
      PTEDD_PTEDD7 = 1;         // Pin as output  
      
      /* Display Heart Beats per Minute */
      Write_Str_LCD ("bpm", 3, 56);  
  
      /* Screen ECG Sweep */
      while(gu8ButtonStatus != BUTTON_EXIT){
        Display_Number ((UINT8)(Averaged_HR), 0x00, 0x14, 3);
        screen_sweep();
      }
      
      ECG_ENABLE=OFF;           // Turn ECG Flag off in TIMER2 routine
      gu8ButtonStatus = BUTTON_IDDLE;
      
    break;    
  
      
    case 2:    
      /**************************************************************************/
      /*                          Food Intake Routine
      /**************************************************************************/      
      gu8ButtonStatus=BUTTON_IDDLE;   
      GetdatafromSD();          // Get Food List from SD
      Table_Manager();          // Init Food Intake Manager
      
    break;    
 
  
    case 3:
      /**************************************************************************/
      /*                           Pedometer Routine
      /**************************************************************************/      
      vfnPrint_SD_Image("PEDOSCR.AMI",0,0); // Print Pedometer Image
      first=True;
      vfnPedometer_Handler();               // Init Pedomoter Handler
      gu8ButtonStatus=BUTTON_IDDLE;

    break;
  
  
    case 4:
      /**************************************************************************/
      /*                           Time Tracking Routine
      /**************************************************************************/   
      vfnTimeTrackingMenu();
   
    break; 
  
    case 5:
      /**************************************************************************/
      /*                         Data Adquisition Routine
      /**************************************************************************/
      //vfnGetSDPersonalData();     // Get Personal Data from SD
      vfnDataAcquisitionMenu();   // Init Personal Data Routine
   
    break;
  
    case 6:
      /**************************************************************************/
      /*                             ZigBee Routine
      /**************************************************************************/
      vfnPrint_SD_Image("ZGBEMENU.AMI",0,0); // Print ZigBee Image
      while(gu8ButtonStatus!=BUTTON_EXIT){   // Waiting for Exit
        TSS_Task();
      }
 
    break;
     
  }
  
    charging=!PTFD_PTFD4;

  // CARGANDO
  if(charging){
    batteryflag =0;
  } 
  
  // NO CARGANDO
  if(!charging) {
    batteryflag =1;  
  }
  
  /* Display Main Menu Images */    
  vfnPrint_SD_Image("MAINMENU.AMI",0,0);      
  vfnPrint_SD_Image("USELICO.AMI",2,0);
  vfnPrint_Icon(u8ProgramIndex);
}